const version="1.6";
let pixelRatio=1;
let hScreen,lScreen,lastHScreen,lastLScreen,hFont,hGl,lGl;
let inElectron=(typeof window !== 'undefined' && window.process && window.process.type === "renderer")||false;
let fullScreen=false;
let urlParams = parseURLParams(window.location.href)||[]; 
let rootURL=window.location.href.slice(0,window.location.href.lastIndexOf("/")+1);
let startupTheme= (urlParams["theme"]||"")[0]||"";
function start () {
	if (inElectron) {
		// pas de lames en cas d'appli Electron
		divPartenariatHisto.style.display="none";
	}
	initFullScreen();
	setBarreChargement(0);
	spanVersion.innerHTML=version;
	divCtxMenu.style.display="none";
	clearSearch();
	selectTheme.value="patience";
	redim();
	document.body.style.display="block";
	redim();
	initScene();
	initLoader();
	loadSquelette();
	loadDico();
	updateVisibilite();
	mainLoop();
}

function redim() {
	pixelRatio=window.devicePixelRatio;
	hScreen=document.body.clientHeight;
	lScreen=document.body.clientWidth;
	hFont=hScreen*0.016;
	document.body.style.fontSize=hFont+"px";
	hGl=Math.floor(divGl.getBoundingClientRect().height);
	lGl=Math.floor(divGl.getBoundingClientRect().width);
	hGl2=Math.floor(divModeleGl.getBoundingClientRect().height);
	lGl2=Math.floor(divModeleGl.getBoundingClientRect().width);
	lastHScreen=hScreen;
	lastLScreen=lScreen;
	
	canvLeg.width=lGl;
	canvLeg.height=hGl;
	canvLeg.style.width=lGl+"px";
	canvLeg.style.height=hGl+"px";
	
	if (typeof(renderer)!="undefined") {
		renderer.setSize(lGl,hGl);
		camera.aspect = lGl / hGl;
		camera.updateProjectionMatrix();
	}
	
	if (typeof(renderer2)!="undefined") {
		renderer2.setSize(lGl2,hGl2);
		camera2.aspect = lGl2 / hGl2;
		camera2.updateProjectionMatrix();
	}
}

function poseQuestion (texte,fn1,fn2) {
	divQuestion.style.display="block";
	divContenuQuestion.innerHTML=texte;
	functionReponseOui=fn1;
	functionReponseNon=fn2;
}

function stopVideo() {
	videoOscar.pause();
	divVideo.style.display="none";
}

function repondOui () {
	divQuestion.style.display='none';
	eval(functionReponseOui);
}

function repondNon () {
	divQuestion.style.display='none';
	eval(functionReponseNon);
}


function afficheModeDemploi () {
	divModeDemploi.style.display="block";
}


Object.defineProperty(String.prototype, 'capitalize', {
  value: function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
  },
  enumerable: false
});

function toClipboard (txt) {
	if (tactile) {return false}
	navigator.clipboard.writeText(txt).then(() => {
	  console.log(txt+' copied to clipboard');
	  /* Resolved - text copied to clipboard successfully */
	},() => {
	  console.error('Failed to copy');
	  /* Rejected - text failed to copy to the clipboard */
	});
}

function setBarreChargement (n) {
	let n1=n*80;
	let n2=(1-n)*80;
	divBarreVerte.style.width=n1+"%";
	divBarreGrise.style.width=n2+"%";
}

function initFullScreen () {
	if (document.fullscreenEnabled) {
		document.addEventListener("fullscreenchange", function( event ) {
			if ( document.fullscreen ) {
				fullScreen=true;
				divFullScreen.style.backgroundImage='url("./images/icones/minimize.png")';
				divFullScreen.title="Quitter le mode plein écran";
			} else {
				fullScreen=false;
				divFullScreen.style.backgroundImage='url("./images/icones/full-screen.png")';
				divFullScreen.title="Basculer en plein écran";
			}
			redim();
		})
	}
}

function toggleFullScreen () {
	if (document.fullscreenEnabled) {
		if (!document.fullscreenElement) {
			document.body.requestFullscreen();
		} else {
			if (document.exitFullscreen) {
				document.exitFullscreen(); 
				fullScreen=false;
			}
		}
	}
}

function parseURLParams(url) {
    var queryStart = url.indexOf("?") + 1,
        queryEnd   = url.indexOf("#") + 1 || url.length + 1,
        query = url.slice(queryStart, queryEnd - 1),
        pairs = query.replace(/\+/g, " ").split("&"),
        parms = {}, i, n, v, nv;

    if (query === url || query === "") {
        return;
    }

    for (i = 0; i < pairs.length; i++) {
        nv = pairs[i].split("=");
        n = decodeURIComponent(nv[0]);
        v = decodeURIComponent(nv[1]);

        if (!parms.hasOwnProperty(n)) {
            parms[n] = [];
        }

        parms[n].push(nv.length === 2 ? v : null);
    }
    return parms;
}