let dico = [];
let dicoModeApp=false;
let dicoLoaded=false;

function loadDico () {
	var xObj = new XMLHttpRequest();
	xObj.overrideMimeType("application/json");
	xObj.open('GET', './js/dico.json', true);
	xObj.onreadystatechange = function() {
      if (xObj.readyState === 4 && xObj.status === 200) {
          processLoadedDico(xObj.responseText);
      }
  };
  xObj.send(null);
}

function processLoadedDico (txt) {
	dico=JSON.parse(txt);
	dicoLoaded=true;
}

function doDico (obj) {
	let d=getDico(obj);
	if (d) {
		showDico();
		divDico.innerHTML="<div style='float: left;height:3em;width:3em;background-image:url(\"./images/icones/info.png\");background-size:cover;margin-right:0.5em'>️</div>&nbsp;"+d;
	} else {
		hideDico();
	}
}

function getDico (obj) {
	if ((obj.name)=="modele") {return false} // fin récursion
	// on commence par chercher les correspondances strictes
	let nom=obj.name.split("|")[0];
	for (let d of dico) {
		let k=d.k;
		if (k.includes(nom)) {
			return d.v;
		} 
	}
	let listeMots=extraitsMotsFromNomObj(obj);
	for (let d of dico) {
		let k=d.k;
		if (listeMots.some(c=>k.includes(c))) {
			return d.v;
		} 
	}
	return getDico (obj.parent);
}

function showDico (){
	divDico.style.opacity=1;
}

function hideDico (){
	dicoModeApp=false;
	divDico.style.opacity=0;
}

function dicoAppareil (app) {
	dicoModeApp=true;
	showDico();
	let txt="";
	if (app=="reproducteur") {
		txt="The reproductive system consists of all the organs involved in reproduction.";
	} else if (app=="squelette") {
		txt="The skeleton is part of the musculoskeletal system. It consists of all the bones and cartilage, supported and held together by ligaments.";
	} else if (app=="muscles") {
		txt="Muscles are part of the locomotor system. They are organs that contract to enable the body to move. Most are connected to the skeleton by tendons.";
	} else if (app=="nerveux") {
		txt="The <b>nervous system</b> is part of the <b>musculoskeletal system</b>.<br>It consists mainly of the brain, spinal cord, and nerves. Among other things, it manages sensory information, cognitive functions (memory, intellect), emotions, and coordinates movement.";
	}  else if (app=="circulatoire") {
		txt="<b>The circulatory system</b> is a closed circuit that transports blood from the heart to the various organs and back to the heart.";
	} else if (app=="lymphatique") {
		txt="<b>The lymphatic system</b> has a dual function of defending the body and eliminating waste products. It consists of vessels, lymph nodes, and other organs such as the spleen and thymus.";
	} else if (app=="respiratoire") {
		txt="<b>The respiratory system</b> is the set of organs that transport oxygen (O<sub>2</sub>) from the air to the blood and eliminate carbon dioxide (CO<sub>2</sub>) produced during cellular respiration.";
	} else if (app=="excreteur") {
		txt="<b>The excretory system</b> consists of all the organs that eliminate waste produced by the body, mainly through urine.";
	} else if (app=="endocrinien") {
		txt="<b>The endocrine system</b> is a system of organs and glands that produce and release hormones into the blood to regulate various body functions, such as growth, metabolism, and reproduction.";
	}  else if (app=="digestif") {
		txt="<b>The digestive system</b> is the set of organs that convert food into nutrients. It mainly includes the digestive tract (stomach, intestines, etc.) and the digestive glands (liver, pancreas, etc.).";
	}
	divDico.innerHTML="<span style='font-size: larger'>ℹ️</span>&nbsp;"+txt;
	
}