let dico = [];
let dicoModeApp=false;
let dicoLoaded=false;

function loadDico () {
	var xObj = new XMLHttpRequest();
	xObj.overrideMimeType("application/json");
	xObj.open('GET', './js/dico.json', true);
	xObj.onreadystatechange = function() {
      if (xObj.readyState === 4 && xObj.status === 200) {
          processLoadedDico(xObj.responseText);
      }
  };
  xObj.send(null);
}

function processLoadedDico (txt) {
	dico=JSON.parse(txt);
	dicoLoaded=true;
}

function doDico (obj) {
	let d=getDico(obj);
	if (d) {
		showDico();
		divDico.innerHTML="<div style='float: left;height:3em;width:3em;background-image:url(\"./images/icones/info.png\");background-size:cover;margin-right:0.5em'>️</div>&nbsp;"+d;
	} else {
		hideDico();
	}
}

function getDico (obj) {
	if ((obj.name)=="modele") {return false} // fin récursion
	// on commence par chercher les correspondances strictes
	let nom=obj.name.split("|")[0];
	for (let d of dico) {
		let k=d.k;
		if (k.includes(nom)) {
			return d.v;
		} 
	}
	let listeMots=extraitsMotsFromNomObj(obj);
	for (let d of dico) {
		let k=d.k;
		if (listeMots.some(c=>k.includes(c))) {
			return d.v;
		} 
	}
	return getDico (obj.parent);
}

function showDico (){
	divDico.style.opacity=1;
}

function hideDico (){
	dicoModeApp=false;
	divDico.style.opacity=0;
}

function dicoAppareil (app) {
	dicoModeApp=true;
	showDico();
	let txt="";
	if (app=="reproducteur") {
		txt="<b>El aparato reproductor</b> está formado por el conjunto de órganos que participan en la reproducción.";
	} else if (app=="squelette") {
		txt="El <b>esqueleto</b> forma parte del <b>aparato locomotor</b>.<br>Está formado por el conjunto de huesos y cartílagos, sostenidos y reforzados por los ligamentos.";
	} else if (app=="muscles") {
		txt="Los <b>músculos</b> forman parte del <b>aparato locomotor</b>. Son los órganos que, al contraerse, permiten los movimientos del cuerpo. La mayoría están unidos al esqueleto por tendones.";
	} else if (app=="nerveux") {
		txt="El <b>sistema nervioso</b> forma parte del <b>aparato locomotor</b>.<br>Está compuesto principalmente por el encéfalo, la médula espinal y los nervios. Entre otras funciones, gestiona la información sensorial, las funciones cognitivas (memoria, intelecto) y las emociones, y coordina los movimientos.";
	}  else if (app=="circulatoire") {
		txt="<b>El aparato circulatorio</b> es un circuito cerrado que garantiza el transporte de la sangre desde el corazón hacia los distintos órganos y, a su vez, desde estos hacia el corazón.";
	} else if (app=="lymphatique") {
		txt="<b>El sistema linfático</b> tiene una doble función: defender y eliminar los desechos del cuerpo humano. Está formado por vasos, ganglios y otros órganos como el bazo y el timo.";
	} else if (app=="respiratoire") {
		txt="<b>El aparato respiratorio</b> es el conjunto de órganos que permiten transportar el dióxido de oxígeno (O<sub>2</sub>) del aire a la sangre y eliminar el dióxido de carbono (CO<sub>2</sub>) producido durante la respiración celular.";
	} else if (app=="excreteur") {
		txt="<b>El aparato excretor</b> está formado por el conjunto de órganos que eliminan los desechos producidos por el cuerpo, principalmente a través de la orina.";
	} else if (app=="endocrinien") {
		txt="<b>El aparato endocrino</b> es un sistema de órganos y glándulas que producen y liberan hormonas en la sangre para regular diversas funciones del cuerpo, como el crecimiento, el metabolismo y la reproducción.";
	}  else if (app=="digestif") {
		txt="<b>El aparato digestivo</b> es el conjunto de órganos que transforman los alimentos en nutrientes. Comprende principalmente el tubo digestivo (estómago, intestino, etc.) y las glándulas digestivas (hígado, páncreas, etc.).";
	}
	divDico.innerHTML="<span style='font-size: larger'>ℹ️</span>&nbsp;"+txt;
	
}