let dico = [];
let dicoModeApp=false;
let dicoLoaded=false;

function loadDico () {
	var xObj = new XMLHttpRequest();
	xObj.overrideMimeType("application/json");
	xObj.open('GET', './js/dico.json', true);
	xObj.onreadystatechange = function() {
      if (xObj.readyState === 4 && xObj.status === 200) {
          processLoadedDico(xObj.responseText);
      }
  };
  xObj.send(null);
}

function processLoadedDico (txt) {
	dico=JSON.parse(txt);
	dicoLoaded=true;
}

function doDico (obj) {
	let d=getDico(obj);
	if (d) {
		showDico();
		divDico.innerHTML="<div style='float: left;height:3em;width:3em;background-image:url(\"./images/icones/info.png\");background-size:cover;margin-right:0.5em'>️</div>&nbsp;"+d;
	} else {
		hideDico();
	}
}

function getDico (obj) {
	if ((obj.name)=="modele") {return false} // fin récursion
	// on commence par chercher les correspondances strictes
	let nom=obj.name.split("|")[0];
	for (let d of dico) {
		let k=d.k;
		if (k.includes(nom)) {
			return d.v;
		} 
	}
	let listeMots=extraitsMotsFromNomObj(obj);
	for (let d of dico) {
		let k=d.k;
		if (listeMots.some(c=>k.includes(c))) {
			return d.v;
		} 
	}
	return getDico (obj.parent);
}

function showDico (){
	divDico.style.opacity=1;
}

function hideDico (){
	dicoModeApp=false;
	divDico.style.opacity=0;
}

function dicoAppareil (app) {
	dicoModeApp=true;
	showDico();
	let txt="";
	if (app=="reproducteur") {
		txt="<b>L'appareil reproduteur</b> est constitué de l'ensemble des organes qui participent à la reproduction.";
	} else if (app=="squelette") {
		txt="Le <b>squelette</b> fait partie de <b>l'appareil locomoteur</b>.<br>Il est constitué de l'ensemble des os et cartilages, supportés et étayés par les ligaments.";
	} else if (app=="muscles") {
		txt="Les <b>muscles</b> font partie de <b>l'appareil locomoteur</b>.<br>Ce sont les organes qui assurent, en se contractant, les mouvements du corps. La plupart sont reliés au squelette par des tendons.";
	} else if (app=="nerveux") {
		txt="Le <b>système nerveux</b> fait partie de <b>l'appareil locomoteur</b>.<br>Il est principalement constitué de l'encéphale, de la moelle épinière et des nerfs. Il gère entre autre les informations sensorielles, les fonctions cognitives (mémoire, intellect), les émotions et coordonne les mouvements.";
	}  else if (app=="circulatoire") {
		txt="<b>L'appareil  circulatoire</b> est un circuit fermé qui assure le transport du sang du cœur vers les divers organes et, en retour, de ceux-ci vers le cœur.";
	} else if (app=="lymphatique") {
		txt="<b>Le système lymphatique</b> assure une double fonction de défense et d'élimination des déchets du corps humain.<br>Il est constitué de vaisseaux, de ganglions et d'autres organes tels que la rate et le thymus.";
	} else if (app=="respiratoire") {
		txt="<b>L'appareil respiratoire</b> est l'ensemble des organes qui permettent d'acheminer le dioxygène (O<sub>2</sub>) de l’air vers le sang et d'éliminer le dioxyde de carbone (CO<sub>2</sub>) produit durant la respiration cellulaire.";
	} else if (app=="excreteur") {
		txt="<b>L'appareil excreteur</b> est constitué de l'ensemble des organes qui éliminent les déchets produits par le corps, principalement via l'urine.";
	} else if (app=="endocrinien") {
		txt="<b>L'appareil endocrinien</b> est un système d'organes et de glandes qui produisent et libèrent des hormones dans le sang pour réguler diverses fonctions du corps, comme la croissance, le métabolisme et la reproduction.";
	}  else if (app=="digestif") {
		txt="<b>L'appareil digestif</b> est l'ensemble des organes qui transforment les aliments en nutriments. Il comprend principalement le tube digestif (estomac, intestin, etc.) et les glandes digestives (foie, pancréas etc.).";
	}
	divDico.innerHTML="<span style='font-size: larger'>ℹ️</span>&nbsp;"+txt;
	
}