let dico = [];
let dicoModeApp=false;
let dicoLoaded=false;

function loadDico () {
	var xObj = new XMLHttpRequest();
	xObj.overrideMimeType("application/json");
	xObj.open('GET', './js/dico.json', true);
	xObj.onreadystatechange = function() {
      if (xObj.readyState === 4 && xObj.status === 200) {
          processLoadedDico(xObj.responseText);
      }
  };
  xObj.send(null);
}

function processLoadedDico (txt) {
	dico=JSON.parse(txt);
	dicoLoaded=true;
}

function doDico (obj) {
	let d=getDico(obj);
	if (d) {
		showDico();
		divDico.innerHTML="<div style='float: left;height:3em;width:3em;background-image:url(\"./images/icones/info.png\");background-size:cover;margin-right:0.5em'>️</div>&nbsp;"+d;
	} else {
		hideDico();
	}
}

function getDico (obj) {
	if ((obj.name)=="modele") {return false} // fin récursion
	// on commence par chercher les correspondances strictes
	let nom=obj.name.split("|")[0];
	for (let d of dico) {
		let k=d.k;
		if (k.includes(nom)) {
			return d.v;
		} 
	}
	let listeMots=extraitsMotsFromNomObj(obj);
	for (let d of dico) {
		let k=d.k;
		if (listeMots.some(c=>k.includes(c))) {
			return d.v;
		} 
	}
	return getDico (obj.parent);
}

function showDico (){
	divDico.style.opacity=1;
}

function hideDico (){
	dicoModeApp=false;
	divDico.style.opacity=0;
}

function dicoAppareil (app) {
	dicoModeApp=true;
	showDico();
	let txt="";
	if (app=="reproducteur") {
		txt="<b>Репродуктивная система</b> состоит из всех органов, участвующих в размножении.";
	} else if (app=="squelette") {
		txt="<b>Скелет</b> является частью <b>опорно-двигательной системы</b>.<br>Он состоит из всех костей и хрящей, поддерживаемых и укрепляемых связками.";
	} else if (app=="muscles") {
		txt="<b>Мышцы</b> являются частью <b>опорно-двигательного аппарата</b>.<br>Это органы, которые, сокращаясь, обеспечивают движения тела. Большинство из них соединены со скелетом сухожилиями.";
	} else if (app=="nerveux") {
		txt="<b>Нервная система</b> является частью <b>опорно-двигательного аппарата</b>.<br>Она состоит в основном из головного мозга, спинного мозга и нервов. Она управляет, среди прочего, сенсорной информацией, когнитивными функциями (память, интеллект), эмоциями и координирует движения.";
	}  else if (app=="circulatoire") {
		txt="<b>Кровеносная система</b> представляет собой замкнутый круг, который обеспечивает транспортировку крови от сердца к различным органам и обратно.";
	} else if (app=="lymphatique") {
		txt="<b>Лимфатическая система</b> выполняет двойную функцию защиты и выведения отходов из организма человека. Она состоит из сосудов, узлов и других органов, таких как селезенка и вилочковый орган.";
	} else if (app=="respiratoire") {
		txt="<b>Дыхательная система</b> — это совокупность органов, которые обеспечивают поступление кислорода (O<sub>2</sub>) из воздуха в кровь и выведение углекислого газа (CO<sub>2</sub>), образующегося в процессе клеточного дыхания.";
	} else if (app=="excreteur") {
		txt="<b>Выделительная система</b> состоит из всех органов, которые выводят из организма продукты жизнедеятельности, в основном с мочой.";
	} else if (app=="endocrinien") {
		txt="<b>Эндокринная система</b> — это система органов и желез, которые производят и выделяют в кровь гормоны, регулирующие различные функции организма, такие как рост, обмен веществ и размножение.";
	}  else if (app=="digestif") {
		txt="<b>Пищеварительная система</b> — это совокупность органов, которые преобразуют пищу в питательные вещества. Она включает в себя в основном пищеварительный тракт (желудок, кишечник и т. д.) и пищеварительные железы (печень, поджелудочная железа и т. д.).";
	}
	divDico.innerHTML="<span style='font-size: larger'>ℹ️</span>&nbsp;"+txt;
	
}