let tLegendes=[];
let lastILegende=0;

function removeLegende (leg) {
	leg.div.remove();
	let oldSphere=leg.sphere;
	let oldOrgane=leg.organe;
	oldOrgane.remove(oldSphere);
	oldOrgane.hasLegende=false;
	tLegendes=tLegendes.filter(c=>c!=leg);
	if (tLegendes.length==0) {clearLegendesCanvas()}
}

function removeAllLegendes () {
	ctxMouseOut();
	for (let leg of tLegendes) {
		removeLegende(leg);
	}
	clearLegendesCanvas();
}

function addLegende (x,y,nomImpose) {
	// ajoute une légende correspondant à l'organe
	// présent sous les coordonnées d'écran x,y
	// nomImpose est facultatif, et permet d'imposer le texte de la légende
	restoreOldMaterial();	
	
	let interAtXY=getInterUnderCursor(x,y);
	
	if ( interAtXY ) {
		let obj=interAtXY.object;
		if (obj.hasLegende) {
			// on retire la légende précédente
			let oldLeg=tLegendes.find(c=>c.organe==obj);
			removeLegende(oldLeg);
		}
		let leg={};
		leg.organe=obj;
		if (typeof(nomImpose)!="undefined") {
			leg.txt=nomImpose;
		} else {
			leg.txt=cleanNameFromObj(obj);
		}
		let pt=interAtXY.point;
		leg.pt=pt;
		leg.visible=true;
		let matSphere= new THREE.MeshBasicMaterial( {color: '#FF0000'} );
		let sphere=new THREE.Mesh(new THREE.IcosahedronGeometry(0.02,1), matSphere);
		sphere.visible=false;
		sphere.name="sphereLegende";
		sphere.isLegende=true;
		let globalPos = new THREE.Vector3(pt.x, pt.y, pt.z);
		let localPos=obj.worldToLocal (globalPos);
		sphere.position.set (localPos.x,localPos.y,localPos.z);
		obj.hasLegende=true;
		obj.add(sphere);
		leg.sphere=sphere;
		
		let divLeg = document.createElement('div');
		divLeg.className = 'legende';
		divLeg.innerHTML=leg.txt;
		divContLeg.appendChild(divLeg);

		leg.div=divLeg;		
		
		tLegendes.push(leg);
		reScaleSpheresLegende();
		drawLegendes();
	} 
}

function clearLegendesCanvas () {
	canvLeg.getContext("2d").clearRect (0,0,lGl,hGl);
}

function drawLegendes() {
	reScaleSpheresLegende();
	let ctx=canvLeg.getContext("2d");
	let hCanv=hGl;
	let lCanv=lGl;
	let xMilieu=lCanv/2;
	let xMargeG=12*hFont;
	let xMargeD=lCanv-xMargeG;
	ctx.clearRect (0,0,lGl,hGl);
	calcPosLeg();
	for (let leg of tLegendes) {
		if (leg.visible) {
			leg.div.style.display="block";
			if (leg.xpr<xMilieu) {
				if (leg.xpr>xMargeG) {
					ctx.fillStyle="white";
					ctx.fillRect(leg.xpr,leg.ypr,xMargeG-leg.xpr,1);
					ctx.fillStyle="black";
					ctx.fillRect(leg.xpr,leg.ypr+1,xMargeG-leg.xpr,1);
					leg.div.style.textAlign="right";
					leg.div.style.left="";
					leg.div.style.right=lGl-xMargeG+"px";
					leg.div.style.top=leg.y+"px";
				} else {
					leg.div.style.display="none";
				}
			} else {
				if (leg.xpr<xMargeD) {
					ctx.fillStyle="white";
					ctx.fillRect(leg.xpr,leg.ypr,xMargeD-leg.xpr,1);
					ctx.fillStyle="black";
					ctx.fillRect(leg.xpr,leg.ypr+1,xMargeD-leg.xpr,1);
					leg.div.style.textAlign="left";
					leg.div.style.right="";
					leg.div.style.left=xMargeD+"px";
					leg.div.style.top=leg.y+"px";
				} else {
					leg.div.style.display="none";
				}
			}
		} else {
			leg.div.style.display="none";
		}
		ctx.fillStyle="green";
		ctx.fillRect(leg.x,leg.y,1,1);
	}
}

function reScaleSpheresLegende () {
	let sc=Math.sqrt(distCam/5);
	for (let leg of tLegendes) {
		leg.sphere.scale.set(sc,sc,sc);
	}
}

function checkVisibiliteLegendes () {
	if (tLegendes.length==0) {return false}
	lastILegende++;
	if (lastILegende>=tLegendes.length) {lastILegende=0}
	
	if (allParentVisible(tLegendes[lastILegende].organe)==false) {
		tLegendes[lastILegende].visible=false;
	} else {
		tLegendes[lastILegende].visible=checkVisiDansScene(tLegendes[lastILegende]);
	}
}

function calcPosLeg () {
	let hCanv=hGl;
	let lCanv=lGl;
	camera.updateMatrixWorld();
	for (let leg of tLegendes) {
		
		let localPos=leg.sphere.position.clone();
		let globalPos=leg.organe.localToWorld (localPos);
		
		let vector=globalPos.project( camera );
		//console.log(pos,vector);
		leg.x = ( vector.x + 1) * lCanv / 2-0.5;
		leg.xpr = leg.x; 
		leg.y = - ( vector.y - 1) * hCanv / 2-0.5;
		leg.ypr = leg.y;
	}
}

function extraitsMotsFromNomObj (objAtXY) {
	let nom=objAtXY.name.toLowerCase();
	nom=nom.replace(/_/g, ' ');
	nom=nom.replace(/'/g, ' ');
	nom=nom.split("|")[0];
	nom=nom.split("Bezier")[0];
	nom=nom.split("grp")[0];
	nom=nom.replace("(D)","");
	nom=nom.replace("(G)","");
	nom=nom.replace("(R)","");
	nom=nom.replace("(L)","");
	nom=nom.replace(/\(|\)/g," ")
	nom=nom.trim();
	nom=nom.normalize('NFD').replace(/[\u0300-\u036f]/g, '');
	
	if ((objAtXY?.material?.name.toLowerCase().includes("cartilage"))&&(!nom.toLowerCase().includes("cartilage"))) {
		nom+=" cartilage";
	}
	if ((objAtXY?.material?.name.toLowerCase().includes("tendon"))&&(!nom.toLowerCase().includes("tendon"))&&(!nom.toLowerCase().includes("aponévrose"))) {
		nom+=" tendon";
	}
	return nom.split(" ").filter(c=>c.length>1);
}

function objetAppartientAppareil (obj,app) {
	let o=obj;
	while (o.parent) {
		if (o.name==app) {return true}
		o=o.parent;
	}
	return false;
}

function cleanNameFromObj (objAtXY) {
	let nom=objAtXY.name;
	nom=nom.replace(/_/g, ' ')
	nom=nom.split("|")[0];
	nom=nom.split("Bezier")[0];
	nom=nom.split("grp")[0];
	nom=nom.replace("(D)","");
	nom=nom.replace("(G)","");
	nom=nom.replace("(R)","");
	nom=nom.replace("(L)","");
	nom=nom.trim();
	if ((objAtXY?.material?.name.toLowerCase().includes("cartilage"))&&(!nom.toLowerCase().includes("cartilage"))&&(objetAppartientAppareil(objAtXY,"squelette"))) {
		//Si le material est du cartilage ET que le nom d'inclut pas déjà le mot cartilage
		nom+="\n(cartilage)";
	}
	if ((objAtXY?.material?.name.toLowerCase().includes("tendon"))&&(!nom.toLowerCase().includes("tendon"))&&(!nom.toLowerCase().includes("aponévrose"))) {
		nom+="\n(tendon)";
	}
	return nom;
}


function shrinkWrap(element) {
	// permet de resserrer la largeur du div après un word wrap
	element.style.width="";
  const { firstChild, lastChild } = element;
  if (!element || !firstChild || !lastChild) return;
  const range = document.createRange();
  range.setStartBefore(firstChild);
  range.setEndAfter(lastChild);
  const { width } = range.getBoundingClientRect();
  element.style.width = width + "px";
  element.style.boxSizing = "content-box";
}