let nLoaded=0;
let nToLoad=28;
let appareilsTousCharges=false;
let loader,dracoloader;
function initLoader () {
	loader = new GLTFLoader();
	dracoLoader = new DRACOLoader();
	dracoLoader.setDecoderPath( './js/three/examples/jsm/libs/draco/' );
	dracoLoader.preload();
	loader.setDRACOLoader( dracoLoader );	
}

function loadSquelette () {
	modele.visible=false;
	loader.load("modeles/squelette.bin", function ( gltf ) {
		squelette=gltf.scene;
		
		doShadeSmoothGroup(squelette);
		
		crane=getObjectByStrictName(squelette,"Crâne|");
		dents=getObjectByStrictName(squelette,"Dents|");
		
		moelleOsseuse=new THREE.Object3D();
		moelleOsseuse.name="moelle osseuse";
		let extra=getOrgansByNameWhoContains(squelette,"moelle");
		for (let organe of extra) {
			moelleOsseuse.add(organe);			
		}
	
		squelette.name="squelette";
		loadBassinM();
		tVisible.push("squelette");
		updateVisibilite();
		avanceLoad();
	});	
}


function loadBassinM () {
	loader.load("modeles/bassinm.bin", function ( gltf ) {
		bassinM=gltf.scene;
		bassinM.name="bassinM";
		doShadeSmoothGroup(bassinM);
		squelette.add(bassinM);
		
		moelleOsseuseM=new THREE.Object3D();
		moelleOsseuseM.name="moelle osseuse M";
		let extra=getOrgansByNameWhoContains(bassinM,"moelle");
		for (let organe of extra) {
			moelleOsseuseM.add(organe);			
		}
		
		loadBassinF();
		avanceLoad();
	});	
}

function loadBassinF () {
	loader.load("modeles/bassinf.bin", function ( gltf ) {
		bassinF=gltf.scene;
		bassinF.name="bassinF";
		doShadeSmoothGroup(bassinF);
		squelette.add(bassinF);
		
		moelleOsseuseF=new THREE.Object3D();
		moelleOsseuseF.name="moelle osseuse F";
		let extra=getOrgansByNameWhoContains(bassinF,"moelle");
		for (let organe of extra) {
			moelleOsseuseF.add(organe);			
		}
		
		tVisible.push("squelette");
		updateVisibilite();
		loadDigestif();
		avanceLoad();
	});	
}

function loadDigestif () {
	loader.load("modeles/digestif.bin", function ( gltf ) {
		digestif=gltf.scene;
		digestif.name="digestif";
		doShadeSmoothGroup(digestif);
		tVisible.push("digestif");
		
		pancreas=new THREE.Object3D();
		pancreas.name="pancreas";
		let extra=digestif.children.filter(c=>c.name.includes("Pancréas"));
		for (let panc of extra) {
			pancreas.add(panc);			
		}
		modele.add(pancreas);
		
		let tPharynx=getOrgansByNameWhoContains(digestif,"pharynx");
		pharynx=new THREE.Object3D();
		pharynx.name="pharynx";
		for (let organe of tPharynx) {
			pharynx.add(organe);			
		}
		modele.add(pharynx);
		
		updateVisibilite();
		loadExcreteurM();
		avanceLoad();
	});	
}

function loadExcreteurM () {
	loader.load("modeles/excreteurm.bin", function ( gltf ) {
		excreteurm=gltf.scene;
		excreteurm.name="excreteurm";
		doShadeSmoothGroup(excreteurm,false);
		excreteur.add(excreteurm);
		loadExcreteurF();
		avanceLoad();
	});	
}

function loadExcreteurF () {
	loader.load("modeles/excreteurf.bin", function ( gltf ) {
		excreteurf=gltf.scene;
		excreteurf.name="excreteurf";
		doShadeSmoothGroup(excreteurf,false);
		excreteur.add(excreteurf);
		tVisible.push("excreteur");
		updateVisibilite();
		loadEndocrinien();
		avanceLoad();
	});	
}

function loadEndocrinien () {
	loader.load("modeles/endocrinien.bin", function ( gltf ) {
		endocrinien=gltf.scene;
		endocrinien.name="endocrinien";
		doShadeSmoothGroup(endocrinien);
		excreteur.add(endocrinien);
		tVisible.push("endocrinien");
		updateVisibilite();
		loadReproducteurM();
		avanceLoad();
	});	
}

function loadReproducteurM () {
	loader.load("modeles/reproducteurm.bin", function ( gltf ) {
		reproducteurm=gltf.scene;
		reproducteurm.name="reproducteurm";
		doShadeSmoothGroup(reproducteurm);
		reproducteur.add(reproducteurm);
		
		testicules=new THREE.Object3D();
		testicules.name="testicules";
		let extra=reproducteurm.children.filter(c=>c.name.includes("Testicule"));
		for (let testi of extra) {
			testicules.add(testi);			
		}
		modele.add(testicules);
		
		updateVisibilite();
		loadReproducteurF();
		avanceLoad();
	});	
}

function loadReproducteurF () {
	loader.load("modeles/reproducteurf.bin", function ( gltf ) {
		reproducteurf=gltf.scene;
		reproducteurf.name="reproducteurf";
		doShadeSmoothGroup(reproducteurf);
		reproducteur.add(reproducteurf);
				
		ovaires=new THREE.Object3D();
		ovaires.name="ovaires";
		let extra=reproducteurf.children.filter(c=>c.name.includes("Ovaire"));
		for (let ov of extra) {
			ovaires.add(ov);			
		}
		modele.add(ovaires);
		
		loadMammaires();
		avanceLoad();
	});	
}

function loadMammaires () {
	loader.load("modeles/mammaires.bin", function ( gltf ) {
		mammaires=gltf.scene;
		mammaires.name="mammaires";
		doShadeSmoothGroup(mammaires);
		reproducteurf.add(mammaires);
		tVisible.push("reproducteur");
			
		updateVisibilite();
		loadCirculatoire();
		avanceLoad();
	});	
}


function loadCirculatoire () {
	loader.load("modeles/circulatoire.bin", function ( gltf ) {
		circulatoire=gltf.scene;
		circulatoire.name="circulatoire";
		doShadeSmoothGroup(circulatoire);
		tVisible.push("circulatoire");
		coeur=getObjectByStrictName(circulatoire,"Coeur|");
		loadVaisseauxM();
		avanceLoad();
	});	
}

function loadVaisseauxM () {
	loader.load("modeles/vaisseauxm.bin", function ( gltf ) {
		vaisseauxM=gltf.scene;
		vaisseauxM.name="vaisseauxM";
		doShadeSmoothGroup(vaisseauxM);
		circulatoire.add(vaisseauxM);
		loadVaisseauxF();
		avanceLoad();
	});	
}

function loadVaisseauxF () {
	loader.load("modeles/vaisseauxf.bin", function ( gltf ) {
		vaisseauxF=gltf.scene;
		vaisseauxF.name="vaisseauxF";
		doShadeSmoothGroup(vaisseauxF);
		circulatoire.add(vaisseauxF);
		loadRespiratoire();
		avanceLoad();
	});	
}


function loadRespiratoire () {
	loader.load("modeles/respiratoire.bin", function ( gltf ) {
		respiratoire=gltf.scene;
		respiratoire.name="respiratoire";
		doShadeSmoothGroup(respiratoire,false);
		tVisible.push("respiratoire");
		updateVisibilite();
		loadNerveux();
		avanceLoad();
	});	
}

function loadNerveux () {
	loader.load("modeles/nerveux.bin", function ( gltf ) {
		nerveux=gltf.scene;
		nerveux.name="nerveux";
		doShadeSmoothGroup(nerveux);
		
		chh=getObjectByStrictName(nerveux,"Complexe_hypothalamo-hypophysaire|");
		cerveau=getObjectByStrictName(nerveux,"Cerveau|");
		epiphyse=getObjectByStrictName(nerveux,"Epiphyse|");
		hypophyse=getObjectByStrictName(nerveux,"Hypophyse|");
		loadNerveuxM();
		avanceLoad();
	});	
}


function loadNerveuxM () {
	loader.load("modeles/nerveuxm.bin", function ( gltf ) {
		nerveuxM=gltf.scene;
		nerveuxM.name="nerveuxM";
		doShadeSmoothGroup(nerveuxM);
		nerveux.add(nerveuxM);
		loadNerveuxF();
		avanceLoad();
	});	
}

function loadNerveuxF () {
	loader.load("modeles/nerveuxf.bin", function ( gltf ) {
		nerveuxF=gltf.scene;
		nerveuxF.name="nerveuxF";
		doShadeSmoothGroup(nerveuxF);
		nerveux.add(nerveuxF);
		tVisible.push("nerveux");
		updateVisibilite();
		loadMuscles();
		avanceLoad();
	});	
}

function loadMuscles () {
	loader.load("modeles/muscles.bin", function ( gltf ) {
		muscles=gltf.scene;
		muscles.name="muscles";
		doShadeSmoothGroup(muscles);	
		loadMusclesM();
		avanceLoad();
	});	
}

function loadMusclesM () {
	loader.load("modeles/musclesm.bin", function ( gltf ) {
		musclesM=gltf.scene;
		musclesM.name="musclesM";
		doShadeSmoothGroup(musclesM);
		muscles.add(musclesM);
		loadMusclesF();
		avanceLoad();
	});	
}

function loadMusclesF () {
	loader.load("modeles/musclesf.bin", function ( gltf ) {
		musclesF=gltf.scene;
		musclesF.name="musclesF";
		doShadeSmoothGroup(musclesF);
		muscles.add(musclesF);
		tVisible.push("muscles");
		updateVisibilite();
		loadLymphatique();
		avanceLoad();
	});	
}

function loadLymphatique () {
	loader.load("modeles/lymphatique.bin", function ( gltf ) {
		lymphatique=gltf.scene;
		lymphatique.name="lymphatique";
		doShadeSmoothGroup(lymphatique);
		loadVLymphatique();
		avanceLoad();
	});	
}

function loadLymphatique () {
	loader.load("modeles/lymphatique.bin", function ( gltf ) {
		lymphatique=gltf.scene;
		lymphatique.name="lymphatique";
		doShadeSmoothGroup(lymphatique);
		lymphatique.add(moelleOsseuse);
		loadVLymphatique();
		avanceLoad();
	});	
}


function loadVLymphatique () {
	loader.load("modeles/vlymphe.bin", function ( gltf ) {
		vlymphatique=gltf.scene;
		vlymphatique.name="vlymphatique";
		doShadeSmoothGroup(vlymphatique);
		lymphatique.add(vlymphatique);
		loadVLympheF();
		avanceLoad();
	});	
}


function loadVLympheF () {
	loader.load("modeles/vlymphef.bin", function ( gltf ) {
		vlymphef=gltf.scene;
		vlymphef.name="vlymphef";
		doShadeSmoothGroup(vlymphef);
		lymphatique.add(vlymphef);
		vlymphef.add(moelleOsseuseF);
		loadVLympheM();
		avanceLoad();
	});	
}

function loadVLympheM () {
	loader.load("modeles/vlymphem.bin", function ( gltf ) {
		vlymphem=gltf.scene;
		vlymphem.name="vlymphef";
		doShadeSmoothGroup(vlymphem);
		lymphatique.add(vlymphem);
		vlymphem.add(moelleOsseuseM);
		tVisible.push("lymphatique");
		updateVisibilite();
		loadLigaments();
		avanceLoad();
	});	
}

function loadLigaments () {
	loader.load("modeles/ligaments.bin", function ( gltf ) {
		ligaments=gltf.scene;
		ligaments.name="ligaments";
		doShadeSmoothGroup(ligaments);
		loadLigamentsM();
		avanceLoad();
	});	
}

function loadLigamentsM () {
	loader.load("modeles/ligamentsm.bin", function ( gltf ) {
		ligamentsM=gltf.scene;
		ligamentsM.name="ligamentsM";
		doShadeSmoothGroup(ligamentsM);
		loadLigamentsF();
		avanceLoad();
	});	
}

function loadLigamentsF () {
	loader.load("modeles/ligamentsf.bin", function ( gltf ) {
		ligamentsF=gltf.scene;
		ligamentsF.name="ligamentsF";
		doShadeSmoothGroup(ligamentsF);
		squelette.add(ligamentsM);
		squelette.add(ligamentsF);
		squelette.add(ligaments);
		loadPeau();
		avanceLoad();
	});	
}

function loadPeau () {
	loader.load("modeles/peau-avant-bras.bin", function ( gltf ) {
		doShadeSmoothGroup(gltf.scene);
		peau=gltf.scene.children[0];
		peau.name="peau";
		peau.visible=false;
		modele.add(peau);
		finaliseLoad();
	});	
}


function finaliseLoad () {
	appareilsTousCharges=true;
	divSelectTheme.className="";
	selectTheme.value="none";
	selectTheme.remove(0);
	videoOscar.src="images/oscar3d.mp4";
	divSplashCont.style.display="none";
	divPlanDeCoupe.className="";
	modele.visible=true;
	checkDateEaster();
	if (startupTheme!="") {
		doSelectTheme(startupTheme);
	}
}

function avanceLoad () {
	nLoaded++;
	let progression=nLoaded/nToLoad;
	setBarreChargement(progression);
}