let listeTitre=[];
let modePivot=false;
let objPivot;
let pivotCenter;
let overGl=false;
let mouseButton=-1;
let lastInfoX=0;
let lastInfoY=0;
let lastMouseX=-1;
let lastMouseY=-1;
let lastTimeInfo=0;
let lastClicTime=0;
let previousClick=0;
let lastXInfobulle=0;
let lastYInfobulle=0;
let trajetCumule=0;
let tousDoigtsLeves=true;
let tactile=false;
let iWasZooming=false;

function contextMenu(event) {
	event.preventDefault();
	return false;
}

function bodyTouchStart() {
	tactile=true;
	adaptToMobile();
}

function moletteGl (event) {
	event.preventDefault();
	const delta = Math.sign(event.deltaY);
	if (delta<0) {doZoomIn()} 
	if (delta>0) {doZoomOut()} 
	checkTargetYLimits();
	divInfoBulle.style.opacity=0;
	hideDico();
	mouseButton=-1;
}

function checkTargetYLimits() {
	if (modePivot) {
		// en mode pivot on autorise de se rapprocher de très près
		if (targetDistCam<0.1) {targetDistCam=0.1}
	} else {
		if (targetY>1.5) {
			if (targetDistCam<0.33) {targetDistCam=0.33}
		} else {
			if (targetDistCam<0.55) {targetDistCam=0.55}
		}
	}
	if (targetDistCam>5) {targetDistCam=5}
}

function doZoomIn() {
	targetDistCam=targetDistCam/1.1;
}

function doZoomOut() {
	targetDistCam=targetDistCam*1.1;
}

function touchMove (event) {
	tousDoigtsLeves=false;
	if ((event.touches.length==2)&&(distDoigts0!=null)) {
		// on écarte 2 doigts => zoom
		let x0=event.touches[0].clientX;
		let y0=event.touches[0].clientY;
		let x1=event.touches[1].clientX;
		let y1=event.touches[1].clientY;
		let dx=x1-x0;
		let dy=y1-y0;
		let distDoigts=Math.sqrt(dx*dx+dy*dy);
		if (distDoigts==0) {return false}
		let fz=distDoigts/distDoigts0;
		targetDistCam=targetDistCamBeforePinch/fz;
		checkTargetYLimits();
		iWasZooming=true;
		return false
	}
	if (iWasZooming) {return false}
	if (event.touches.length!=1) {return false}
	let touche0=event.touches[0];
	let mouseX=touche0.clientX;
	let mouseY=touche0.clientY;
	doMouseMove(mouseX,mouseY);
}


function mouseMoveGl (event) {
	event.preventDefault();
	tactile=false;
	let mouseX=event.clientX;
	let mouseY=event.clientY;
	doMouseMove(mouseX,mouseY);
}

function doMouseMove (mouseX,mouseY) {
	overGl=true;
	lastMouseMove=Date.now();
	
	if (((mouseX-lastXInfobulle)*(mouseX-lastXInfobulle)+(mouseY-lastYInfobulle)*(mouseY-lastYInfobulle))>32) {
		// évite que l'infobulle disparaisse à chaque micromouvement
		cancelInfoBulle();
	}
	
	let deltaX=mouseX-lastMouseX;
	let deltaY=mouseY-lastMouseY;
	if ((mouseButton==0)&&(lastMouseX>=0)) {
		// bouton gauche enfoncé
		movePOV (deltaX,deltaY);
	}
	trajetCumule+=deltaX*deltaX+deltaY*deltaY;
	lastMouseX=mouseX;
	lastMouseY=mouseY;
}

function mouseUpGl (event) {
	event.preventDefault();
	let mouseX=event.clientX;
	let mouseY=event.clientY;
	lastMouseX=event.clientX;
	lastMouseY=event.clientY;
	
	let upTime=Date.now();
	let dureeClic=upTime-lastClicTime;
	mouseButton=-1;
	if (dureeClic>400) {
		// trop lent, ce n'est pas un clic
		return false;
	}
	
	if ((event.button==0)&&(event.shiftKey)) {
		// on vient de finir un clic gauche avec shift enfoncé
		hideUnderCursor(mouseX,mouseY);
	}
	if (event.button==2) {
		// on vient de finir un clic droit
		// on vérifie si on a cliqué droit sur une légende
		for (let leg of tLegendes) {
			let bb=leg.div.getBoundingClientRect();
			if ((mouseX>bb.left)&&(mouseX<bb.right)&&(mouseY>bb.top)&&(mouseY<bb.bottom)) {
				removeLegende (leg);
				drawLegendes();
				event.stopPropagation();
				return false;
			}
		}
		
		// sinon menu contextuel
		openCtxMenu(mouseX,mouseY);
	}
}

function selectDroitByUUID (i,uuid) {
	cancelInfoBulle();
	objDroit=scene.getObjectByProperty( 'uuid' , uuid );
	updateListeTitre(i);
}

function buildListeTitre (obj){
	listeTitre=[];
	while (obj.name.includes("|")) {
		if (listeTitre.length>0) {
			if (cleanNameFromObj(obj)==(cleanNameFromObj(listeTitre[listeTitre.length-1]))) {
				// même nom que le précédent
				listeTitre.splice(-1);
			}
		}
		listeTitre.push(obj);
		obj=obj.parent;
	}
}

function updateListeTitre(nsel) {
	let txt="";
	let n=listeTitre.length;
	let ht="";
	for (let i=n-1;i>=0;i--) {
		let o=listeTitre[i];
		txt+="<div class='ctxMenuElem' style='padding-top:0;padding-bottom:0' onclick='selectDroitByUUID("+i+",\""+o.uuid+"\")'>"+ht+cleanNameFromObj(o);
		if (i==nsel) {
			txt+=" ✓";
		}
		txt+="</div>";
		if (i==(n-1)) {
			ht+="└";
		} else {
			ht="&nbsp;"+ht;
		}
	}
	divCtxMenuTitre.innerHTML=txt;
}

function openCtxMenu (mouseX,mouseY) {
	stopAllMvt();
	xMouseDroit=mouseX;
	yMouseDroit=mouseY;
	restoreOldMaterial();
	divInfoBulle.style.opacity=0;
	
	ctxAfficheAll.style.display="block";
	ctxHr2.style.display="block";
	ctxReset.style.display="block";
	ctxHr1.style.display="none";
	ctxMask.style.display="none";
	ctxIsole.style.display="none";
	ctxAnnote.style.display="none";
	ctxRestoreOpa.style.display="none";
	ctxTransp.style.display="none";
	ctxTranspSauf.style.display="none";
	ctxConsignes.style.display="block";
	ctxResetModele.style.display="block";
	ctxPivot.style.display="none";
	ctxStopPivot.style.display="none";
	
	if (modePivot) {ctxStopPivot.style.display="block"}
		
	if (tLegendes.length==0) {
		ctxEffLegendes.style.display="none";
	} else {
		ctxEffLegendes.style.display="block";
	}
			
	let obj=objUnderCursor(mouseX,mouseY);
	let mtl=getModelToLoad(obj);
	slideToDisplay=getSlideToDisplay(obj);
	
	if ((messageEaster!="")&&(checkEasterUnderCursor(mouseX,mouseY))) {
		divCtxMenuEaster.style.display="block";
		divCtxMenuEaster.innerHTML=messageEaster;
	} else {
		divCtxMenuEaster.style.display="none";
	}
	removeEaster();
	
	if (slideToDisplay==false) {
		ctxVoirMicro.style.display="none";
	} else {
		let divMicroscope="<div class='microscope'></div>&nbsp;";
		ctxVoirMicro.innerHTML=divMicroscope+" <b>Voir une lame </b>"+slideToDisplay.caption;
		ctxVoirMicro.style.display="block";
	}
	
	if (mtl==false) {
		ctxVoirScan.style.display="none";
	} else {
		let divPC="<div class='petitCrane'></div>&nbsp;";
		modelToLoad=mtl.fn;
		dMTL=mtl.d;
		auteurMTL=mtl.auteur;
		titreMTL=mtl.titre;
		ctxVoirScan.innerHTML=divPC+" "+mtl.caption;
		ctxVoirScan.style.display="block";
	}
	
	if (obj==false) {
		let nom="Oscar";
		if (!sexeM) {nom+="ine"}
		nom+=" 3D";
		divCtxMenuTitre.innerHTML=nom;
	} else {
		// un organe sous le clic droit
		doSelectObj(objDroit);
		buildListeTitre(objDroit);
		updateListeTitre(0);
		if ((objDroit.userData.oriMaterial.transparent==false)&&!objDroit.isMadeTransp) {ctxTransp.style.display="block";ctxTranspSauf.style.display="block";}
		if (objDroit.isMadeTransp) {ctxRestoreOpa.style.display="block";}
		ctxConsignes.style.display="none";
		ctxHr1.style.display="block";
		ctxMask.style.display="block";
		ctxIsole.style.display="block";
		ctxAnnote.style.display="block";
		ctxReset.style.display="none";
		ctxHr2.style.display="none";
		ctxAfficheAll.style.display="none";
		ctxResetModele.style.display="none";
		if ((modePivot==false)||(objDroit!=objPivot)) {
			ctxPivot.style.display="block";
		}
	}
	
	divCtxMenu.style.display="block";	
	let y=mouseY;
	let hDiv=divCtxMenu.getBoundingClientRect().height;
	if ((y+hDiv)>hGl) {
		y=hGl-hDiv;
	}
	
	divCtxMenu.style.left=mouseX+"px";
	divCtxMenu.style.top=y+"px";
}

function addLegendeDroit () {
	ctxMouseOut();
	addLegende (xMouseDroit,yMouseDroit,cleanNameFromObj(objDroit));
}

function ctxMouseOut () {
	restoreOldMaterial();
	closeCtxMenu();
}

function closeCtxMenu() {
	divCtxMenu.style.display="none";
}

function bodyMouseDown (event) {
	//event.preventDefault();
	ctxMouseOut();
}


function touchStart (event) {
	tousDoigtsLeves=false;
	if (event.touches.length==2) {
		// 2 doigts sur l'écran
		let x0=event.touches[0].clientX;
		let y0=event.touches[0].clientY;
		let x1=event.touches[1].clientX;
		let y1=event.touches[1].clientY;
		let dx=x1-x0;
		let dy=y1-y0;
		distDoigts0=Math.sqrt(dx*dx+dy*dy);
		targetDistCamBeforePinch=targetDistCam;
		iWasZooming=true;
		return false;
	}
	distDoigts0=null;
	if (event.touches.length!=1) {return false}
	event.preventDefault();
	mouseButton=0;
	
	let touche0=event.touches[0];
	lastMouseX=touche0.clientX;
	lastMouseY=touche0.clientY;
	
	doMouseDownGl();
}

function mouseDownGl (event) {
	event.preventDefault();
	mouseButton=event.button;
	doMouseDownGl();
}

function doMouseDownGl () {
	trajetCumule=0;
	ctxMouseOut();
	previousClick=lastClicTime;
	lastClicTime=Date.now();
	divInfoBulle.style.opacity=0;
}

function doubleClick (event) {
	let mouseX=event.clientX;
	let mouseY=event.clientY;
	event.preventDefault();
	event.stopPropagation();
	addLegende(mouseX,mouseY);
	mouseButton=-1;
}

function touchCancel (event) {
	distDoigts0=null;
	doMouseOut();
}

function touchEnd (event) {
	event.preventDefault();
	distDoigts0=null;
	if (event.touches.length==0) {
		mouseButton=-1;
		tousDoigtsLeves=true;
		if (iWasZooming) {
			iWasZooming=false;
			return false;
		} 
	} else {
		return false;
	}
	if (iWasZooming) {return false}
	overGl=true;
	let upTime=Date.now();
	let dureeClic=upTime-lastClicTime;
	mouseButton=-1;
	
	if (dureeClic>400) {
		if (trajetCumule<8) {
			// on vient de finir un clic lent sans bouger
			// menu contextuel
			getInfoFromXY(lastMouseX,lastMouseY);
			openCtxMenu(lastMouseX,lastMouseY);
		}
		return false;
	}
	
	// clic court
	
	// double clic
	if (((lastClicTime-previousClick)<800)&(trajetCumule<8)) {
		addLegende(lastMouseX,lastMouseY);
		return false;
	}
	
	// si clic sur une légende on la vire
	for (let leg of tLegendes) {
		let bb=leg.div.getBoundingClientRect();
		if ((lastMouseX>bb.left)&&(lastMouseX<bb.right)&&(lastMouseY>bb.top)&&(lastMouseY<bb.bottom)) {
			removeLegende (leg);
			drawLegendes();
			event.stopPropagation();
			return false;
		}
	}
	
	// clic court simple on affiche la légende
	if ((lastInfoX!=lastMouseX)||(lastInfoY!=lastMouseY)) {
		if (trajetCumule<8) {
			getInfoFromXY(lastMouseX,lastMouseY);
		}
	}
}

function mouseOutGl (event) {
	doMouseOut();
}

function doMouseOut () {
	tousDoigtsLeves=true;
	overGl=false;
	mouseButton=-1;
	divInfoBulle.style.opacity=0;
	hideDico();
}

function keyDown (event) {

}

function keyUp (event) {
	if ((event.code=="KeyV")&&(event.shiftKey)) {
		divVideo.style.display="block";
		videoOscar.src="images/oscar3d.mp4";
		videoOscar.play();
		return false;
	}
	if ((event.code=="KeyE")&&(event.shiftKey)) {
		lanceRandomEaster()
		return false;
	}
	if ((event.code=="NumpadAdd")&&(event.shiftKey)) {
		autoZoom-=0.001;
		return false;
	}
	if (event.code=="Escape") {
		stopVideo();
		closeCtxMenu();		
		clearSearch();
		divModeDemploi.style.display='none';
		divSources.style.display='none';
		exitModelMode();
	}
	//console.log (event);
}

function stopPivot () {
	if (!modePivot) {return false}
	divStopPivot.style.display="none";
	modePivot=false;
	targetRotY+=phi-Math.PI/2;
	targetRotY=targetRotY%(Math.PI*2);
	modele.rotation.y=targetRotY;
	camera.rotation.set(0,0,0);
	camera.position.set(0,targetY,distCam);
	closeCtxMenu();
}

function setPivotOrgane (obj) {
	// place le curseur de pivot au centre du bounding box d'un objet
	divStopPivot.style.display="block";
	scene.updateMatrixWorld();
	objPivot=obj;
	pivotCenter=new THREE.Vector3();
	if (obj.type=="Mesh") {
		obj.geometry.computeBoundingSphere();
		pivotCenter=obj.geometry.boundingSphere.center.clone();
	} else {
		// on doit trouver le centre d'un "groupe"
		bbox = new THREE.Box3();
		bbox.setFromObject( obj );
		bbox.getCenter ( pivotCenter );
	}
	obj.localToWorld( pivotCenter );
	curseur.position.set(pivotCenter.x,pivotCenter.y,pivotCenter.z);
	stopAllMvt();
	//camera.position.y=pivotCenter.y;
	//targetY=camera.position.y;
	if (!modePivot) {
		targetTheta=Math.PI/2;
		targetPhi=Math.PI/2;
		theta=Math.PI/2;
		phi=Math.PI/2;
	}
	modePivot=true;
}

function setPivotDroit() {
	// place le curseur de pivot au centre du bounding box de l'objet clic droit
	setPivotOrgane(objDroit);
	closeCtxMenu();
}

function adaptToMobile () {
	if (isAdaptedToMobile) {return false}
	isAdaptedToMobile=true;
	divTactile1.innerHTML="Le modèle se manipule en déplaçant le doigt sur l'écran. Les mouvements de gauche à droite font pivoter le modèle autour de son axe vertical, tandis que les mouvements de haut en bas le déplacent le long de cet axe.<br>Pincer l'écran permet de se rapprocher ou de s'éloigner du modèle (zoom/dézoom).";
	divTactile2.innerHTML="Il est possible de faire tourner librement le modèle en appuyant longuement sur un organe qui servira de \"pivot\", puis en choisissant \"Pivoter autour de cet organe\" dans le menu contextuel. Un nouvel appui long permettra de mettre fin à ce mode en choisissant \"Cesser de pivoter librement\".";
	divTactile3.innerHTML="Un appui long sur le bouton d'un appareil masquera tous les autres appareils, ce qui permet de limiter l'affichage à un seul appareil en un seul clic.";
	divTactile4.innerHTML="A noter qu'un appui long sur un de ces symboles reviendra à limiter l'affichage à l'appareil reproducteur correspondant.";
	divTactile5.innerHTML="";
	divTactile6.innerHTML="appui long";
	divTactile7.innerHTML="appui court";
	divTactile10.innerHTML="Appui court";
	divTactile11.innerHTML="appui long";
	divTactile20.innerHTML="Utiliser un doigt pour déplacer / faire pivoter le modèle. Pincer l'écran permet de zoomer.";
	divTactile21.innerHTML="Toucher brièvement un organe pour faire apparaître son nom.";
	divTactile22.innerHTML="Appui long";
	divTactile23.innerHTML="Appui court";
}