function searchOrganClick() {
	if (inputTextRecherche.value.includes("(saisir")) {
		inputTextRecherche.value="";
	}
}

function searchInput () {
	let v=inputTextRecherche.value.toLowerCase();
	v=v.normalize('NFD').replace(/[\u0300-\u036f]/g, '');
	if (v.length<3) {clearModelFromSearch(modele);return false}
	markOrganAsSearched(modele,v);
	markGroupAsSearched(modele,v);
}

function markOrganAsSearched (group,txt) {
	// colore les oraganes correspondant à txt
	// n'affecte pas les groupes genre "coeur"
	group.traverse( function( obj ) {
		if ((obj.userData.isOrgan)&&(!obj.isGut)) {
			let nom=extraitsMotsFromNomObj(obj).join(' ');
			if (nom.includes(txt)) {
				obj.material=materialSearch;
			} else {
				if (obj.material==materialSearch) {
					restoreMaterial(obj);		
				}
			}
		}
	})
}
	
function markGroupAsSearched (group,txt) {
	// colore les groupes genre "coeur" correspondant à txt
	group.traverse( function( obj ) {
		if ((obj.children.length>0)&&(!obj.isGut)) {
			let nom=extraitsMotsFromNomObj(obj).join(' ');
			if (nom.includes(txt)) {
				markGroupChildrenAsSearched(obj);
			}
		}
	})
}

function markGroupChildrenAsSearched(group) {
	// colore comme "cherché" tous les children d'un objet
	group.traverse( function( obj ) {
		if ((obj.userData.isOrgan)&&(!obj.isGut)) {
			obj.material=materialSearch;
		}
	})
}

function clearSearch() {
	inputTextRecherche.value="(saisir le nom d'un organe)";
	if (typeof(modele)!="undefined") {
		clearModelFromSearch(modele);
	}
}

function clearModelFromSearch (group) {
	group.traverse( function( obj ) {
		if (obj.userData.isOrgan) {
			if (obj.material==materialSearch) {
				restoreMaterial(obj);
			}
		}
	})
}