let isSlicerActif=false;
let planeCsteSag=0;
let planeCsteCor=0;
let planeCsteAxi=1;
let currentGuttedApp;
let modeleGuts;
let sliceOrient="sag";

function selectPlan (plan) {
	removeEaster();
	if (plan==sliceOrient) {return false}
	boutonPlanAucun.style.outline="";
	boutonPlanAxial.style.outline="";
	boutonPlanSagittal.style.outline="";
	boutonPlanCoronal.style.outline="";
	restoreOldMaterial();
	sliceOrient=plan;
	if (sliceOrient=="aucun") {
		boutonPlanAucun.style.outline="3px solid black";
		stopSlicer();
	} else {
		initSlicer();
	}
	if (sliceOrient=="sagittal") {
		boutonPlanSagittal.style.outline="3px solid black";
		rangePlan.value=planeCsteSag/0.25;
	}
	if (sliceOrient=="coronal") {
		boutonPlanCoronal.style.outline="3px solid black";
		rangePlan.value=planeCsteCor/0.12;
	}
	if (sliceOrient=="axial") {
		boutonPlanAxial.style.outline="3px solid black";
		rangePlan.value=planeCsteAxi-1;
	}
}

function changeRangePlan () {
	let v=rangePlan.value*1;
	if (sliceOrient=="sagittal") {
		planeCsteSag=-v*0.25;
	}
	if (sliceOrient=="coronal") {
		planeCsteCor=v*0.12;
	}
	if (sliceOrient=="axial") {
		planeCsteAxi=v+1;
	}
}

function stopSlicer() {
	isSlicerActif=false;
	divPositionPlan.className="disabled";
	if (typeof(modeleGuts)!="undefined") {
		modele.remove(modeleGuts );
	}	
	renderer.localClippingEnabled = false;
}

function setupSlicer() {
	clipVector = new THREE.Vector3( 1, 0, -1);
	antiClipVector = new THREE.Vector3( -1, 0, 1);
	clipPlanes = [ new THREE.Plane( clipVector, 0 ) ];
	antiClipPlane=	 new THREE.Plane( antiClipVector, 0 );
	planeHelper=new THREE.PlaneHelper(antiClipPlane, 4, 0xff0000);
	planeHelper.visible=false;
	planeHelper.children[0].name="PlaneHelper";
	scene.add(planeHelper);
}

function reattributeClipPlanes () {
	modele.traverse( function( obj ) {
		if (obj.userData.isOrgan) {
			obj.material.clippingPlanes=clipPlanes;		
		}
	})
}

function initSlicer () {
	renderer.localClippingEnabled = true;
	reattributeClipPlanes();	
	addGuts();
	
	divPositionPlan.className="";
	isSlicerActif=true;
}

 function isObjectInScene(object) {
    
	let current_object = object;

	while(current_object.parent !== null) {
		current_object = current_object.parent;

		if(current_object === scene) {
			return true;
		}
	}

	return false;
		
}


function rotateSlicer() {
	let x,y,z;
	let constante;
	if (sliceOrient=="sagittal") {
		x=Math.cos(-modele.rotation.y);
		y=0;
		z=Math.sin(-modele.rotation.y);
		constante=planeCsteSag;
	}
	if (sliceOrient=="coronal") {
		x=-Math.sin(modele.rotation.y);
		y=0;
		z=-Math.cos(modele.rotation.y);
		constante=planeCsteCor;
	}
	if (sliceOrient=="axial") {
		x=0;
		y=-1;
		z=-0;
		constante=planeCsteAxi;
	}
	clipVector.set(x,y,z);
	clipPlanes[0].constant=constante;
	antiClipVector.x=-clipVector.x;
	antiClipVector.y=-clipVector.y;
	antiClipVector.z=-clipVector.z;
}

function addGuts() {
	if (typeof(modeleGuts)!="undefined") {
		modele.remove(modeleGuts );
	}
	let oldRotation=modele.rotation.y;
	modele.rotation.y=0;
	modeleGuts = modele.clone( true );
	modele.rotation.y=oldRotation;
	modeleGuts.name="modeleGuts";
	
	modeleGuts.traverse( function ( object )	{
		if (object.userData.isOrgan && object.visible && (object.material.type!="MeshBasicMaterial")) {
			object.isGut=true;
			let oriMaterialUUID=object.userData.oriMaterial.uuid;
			let newMaterial=listeMaterials.find (c=>c.ori.uuid==oriMaterialUUID).gut;
			object.isGut=true;
			newMaterial.clippingPlanes=clipPlanes;
			object.material=newMaterial;
			object.userData.oriMaterial=newMaterial;
		}
	} );				
	
	//modeleGuts.rotation.y=0;
	modele.add(modeleGuts );
}


function makeAllMaterialsDoubleSide (group,doubleS) {
	doubleS=doubleS||false;
	group.traverse( function( object ) {
		if ( object.material ) {
			if (doubleS) {
				object.material.side=THREE.DoubleSide;
			} else {
				object.material.side=THREE.FrontSide;
			}
		}
	} )
}

function makeAllMaterialsPhong (group) {
	materialPhong = new THREE.MeshPhongMaterial({
		side: THREE.FrontSide
	})
	group.traverse( function( object ) {
		if ( object.material ) {
			let oriMaterial=object.material.clone();
			let newMaterial=materialPhong.clone();
			newMaterial.color=object.material.color.clone();
			newMaterial.opacity=object.material.opacity;
			newMaterial.roughness=object.material.roughness;
			newMaterial.name=object.material.name;
			object.material=newMaterial;
		}
	} );
}
