let modelMode=false;
let modelToLoad="hemicrane-humain-3d";
let slideToDisplay={}
let dMTL=0.7;
let auteurMTL="";
let titreMTL="";

function openSlide () {
	let nLame=slideToDisplay.nLame;
	let itm=slideToDisplay.itm;
	let vue=slideToDisplay.vue;
	let g=0;
	let d=1;
	if (vue==5) {
		g=1;
		d=1;
	}
	let url="https://histologielv.umontpellier.fr//index.php?module=detail&vue="+vue+"&itm="+itm+"&lame="+nLame+"&g="+g+"&d="+d;
	openInNewTab(url);
	closeCtxMenu();
}

function openInNewTab(url) {
  window.open(url, '_blank').focus();
}

function enterModelMode () {
	// entre dans le mode "visualisation d'un modèle isolé"
	divModeleCont.style.display="block";
	redim();
	if (typeof(renderer2)=="undefined") {
		initModelMode();
	}
	controls2.reset();
	camera2.position.set(dMTL,0,dMTL);
	divAuteurModele.innerHTML=auteurMTL;
	divTitreModele.innerHTML=titreMTL;
	modelMode=true;
	loadModeleExterne();
}

function loadModeleExterne() {
	if (typeof(modeleExterne)!="undefined") {
		disposeGroup(modeleExterne);
	}
	loader.load("modeles/externes/"+modelToLoad+".bin", function ( gltf ) {
		modeleExterne=gltf.scene;
		doShadeSmoothGroup2(modeleExterne);
		modeleExterne.scale.set(0.001,0.001,0.001);
		scene2.add(modeleExterne);
	});	
}

function exitModelMode () {
	divModeleCont.style.display="none";
	modelMode=false;
}

function getModelToLoad (obj) {
	obj=obj||false;
	if (obj==false) {return false}
	if (obj.parent.name.includes("Crâne|")) {
		return {fn:"hemicrane-humain-3d",caption:"<b>Voir</b> un hémicrâne (scan réel)",d:0.5,auteur:"CC BY-NC Amaury Tavernier",titre:"Hémicrâne humain"}
	} else if (obj.parent.name.includes("Clitoris|")) {
		return {fn:"clitoris-v2",caption:"<b>Voir</b> un clitoris (modèle)",auteur:"CC BY-NC Philippe Cosentino & Odile Fillot",d:0.2,titre:"Modèle de clitoris"}
	} else if (obj.name.includes("Rein")) {
		return {fn:"rein-coupe-3d",caption:"<b>Voir</b> une coupe de rein (modèle)",d:0.3,auteur:"CC BY CgMac",titre:"Modèle de rein en coupe"}
	} else if (obj.name.includes("poumon")) {
		return {fn:"bloc-coeur-poumons-3d",caption:"<b>Voir</b> un bloc 'Coeur/Poumons' (scan réel)",d:0.6,auteur:"CC BY VisibleHeartLabs",titre:"Bloc coeur-poumons"}
	} else if (obj.parent.name.includes("Coeur")) {
		return {fn:"coeur-coupe-2-3d",caption:"<b>Voir</b> une coupe du coeur (modèle)",d:0.6,auteur:"CC BY-NC-SA E-learning UMCG",titre:"Coupe du coeur (modèle)"}
	} else if ((obj.name.includes("Cerveau"))||(obj.parent.name.includes("Cerveau"))||(obj.parent.name.includes("Encéphale"))||(obj.parent.name.includes("Cervelet"))) {
		return {fn:"scan-encephale-3d",caption:"<b>Voir</b> un encéphale (scan réel)",d:0.6,auteur:"CC BY Shyam Prajapati",titre:"Encéphale issu d'une autopsie"}
	} else if ((obj.name.includes("Testicule"))||(obj.name.includes("Epididyme"))){
		return {fn:"testicule-chien-3d",caption:"<b>Voir</b> un testicule de chien (scan réel)",d:0.4,auteur:"CC BY-NC Philippe Cosentino",titre:"Testicule de chien"}
	} else if (obj.parent.name.includes("Dents|")){
		return {fn:"molaire-mandibulaire-3d",caption:"<b>Voir</b> une molaire (scan réel)",d:0.2,auteur:"CC BY-NC Philippe Cosentino",titre:"Première molaire mandibulaire"}
	} else if (obj.name.includes("pharynx")||obj.name.includes("Langue")||obj.name.includes("Epiglotte")||obj.name.includes("Trachée")){
		return {fn:"pharynx-3d",caption:"<b>Voir</b> un modèle détaillé du pharynx",d:0.4,auteur:"CC BY-SA University of Dundee School of Medicine",titre:"Pharynx"}
	} else if (obj.name.includes("omoplate")||obj.name.includes("Clavicule")||obj.name.includes("Humérus")||obj.name.includes("gléno-humérale")){
		return {fn:"squelette-epaule-3d",caption:"<b>Voir</b> un squelette d'une épaule (scan réel)",d:0.6,auteur:"CC BY-NC Amaury Tavernier",titre:"Epaule gauche humaine"}
	} else if (obj.name.includes("estomac")||obj.name.includes("Estomac")){
		return {fn:"estomac-3d",caption:"<b>Voir</b> l'intérieur de l'estomac (modèle)",d:0.6,auteur:"CC BY Saikiran Pandhina",titre:"Modèle montrant les différentes couches<br>constituant l'estomac"}
	} else if (obj.name.includes("mammaire")||obj.name.includes("galactophore")){
		return {fn:"sein-3d",caption:"<b>Voir</b> un modèle de sein",d:0.4,auteur:"CC BY Arloopa",titre:"Modèle anatomique de sein"}
	}
	return false;
}

function getSlideToDisplay (obj) {
	if (inElectron) {return false} // pas de lames si on est dans Electron
	obj=obj||false;
	if (obj==false) {return false}
	if (obj.name.includes("Epididyme")) {
		return {vue:2,itm:15,nLame:22,caption:"d'épididyme"}
	} else if (obj.name.includes("Testicule")) {
		return {vue:2,itm:35,nLame:2,caption:"de testicule"}
	} else if (obj.name.includes("Langue")) {
		return {vue:1,itm:84,nLame:58,caption:"de langue"}
	} else if (obj.name.includes("Oesophage")) {
		return {vue:1,itm:84,nLame:60,caption:"d'oesophage"}
	} else if (obj.parent.name.includes("Coeur")) {
		return {vue:1,itm:84,nLame:59,caption:"de muscle cardiaque"}
	} else if (obj.name.includes("Ganglion_lymphatique")) {
		return {vue:3,itm:76,nLame:69,caption:"de ganglion lymphatique"}
	} else if (obj.name.includes("Fémur")) {
		return {vue:3,itm:88,nLame:64,caption:"de fémur"}
	} else if (obj.parent.name.includes("Cervelet")) {
		return {vue:1,itm:73,nLame:62,caption:"de cervelet"}
	} else if (obj.parent.name.includes("Oeil")) {
		return {vue:1,itm:28,nLame:29,caption:"d'oeil"}
	} else if (obj.name.includes("Foie")) {
		return {vue:1,itm:17,nLame:20,caption:"de foie"}
	} else if (obj.name.includes("Estomac")) {
		return {vue:1,itm:16,nLame:25,caption:"d'estomac"}
	} else if (obj.name.includes("Intestin_grêle")) {
		return {vue:1,itm:1,nLame:9,caption:"d'intestin grêle"}
	} else if (obj.name.includes("Côlon")) {
		return {vue:1,itm:9,nLame:1,caption:"de côlon"}
	} else if (obj.name.includes("Rectum")) {
		return {vue:1,itm:60,nLame:26,caption:"de rectum"}
	} else if (obj.parent.name.includes("Poumon")) {
		return {vue:2,itm:109,nLame:72,caption:"de poumon"}
	} else if (obj.name.includes("Rein")) {
		return {vue:2,itm:62,nLame:78,caption:"de rein"}
	} else if (obj.parent.name.includes("Cortex")) {
		return {vue:1,itm:19,nLame:52,caption:"de cortex cérébral"}
	} else if (obj.name.includes("parotide")) {
		return {vue:1,itm:31,nLame:28,caption:"de glande parotide"}
	} else if (obj.name.includes("Pancréas")) {
		return {vue:2,itm:56,nLame:34,caption:"de pancréas"}
	}  else if (obj.name.includes("Hypophyse")) {
		return {vue:3,itm:80,nLame:40,caption:"d'adénohypophyse"}
	} else if (obj.name.includes("Moelle_osseuse_rouge")) {
		return {vue:3,itm:161,nLame:110,caption:"de moelle osseuse"}
	} else if (obj.name.includes("Thymus")) {
		return {vue:3,itm:201,nLame:43,caption:"de thymus (d'enfant)"}
	} else if (obj.name.includes("mammaire")) {
		return {vue:5,itm:214,nLame:104,caption:"de sein"}
	} else if (obj.name.includes("Vésicule_biliaire")) {
		return {vue:2,itm:148,nLame:36,caption:"de vésicule biliaire"}
	} else if (obj.name.includes("Utérus")) {
		return {vue:5,itm:207,nLame:105,caption:"d'utérus"}
	} else if (obj.name.includes("Glande_surrénale")) {
		return {vue:5,itm:139,nLame:83,caption:"de glande surrénale"}
	} else if (obj.name.includes("Thyroïde")) {
		return {vue:5,itm:187,nLame:5,caption:"de thyroïde"}
	} else if (obj.name.includes("parathyroïde")) {
		return {vue:5,itm:145,nLame:38,caption:"de parathyroïde"}
	} else if (obj.name.includes("Pénis")) {
		return {vue:2,itm:32,nLame:10,caption:"de pénis"}
	} else if (obj.name.includes("Duodénum")) {
		return {vue:2,itm:51,nLame:12,caption:"de duodénum"}
	} else if (obj.name.includes("Glande_submandibulaire")) {
		return {vue:1,itm:33,nLame:49,caption:"de glande submandibulaire"}
	} else if (obj.name.includes("Prostate")) {
		return {vue:2,itm:43,nLame:8,caption:"de prostate"}
	} else if (obj.name.includes("Ganglion_sympathique")) {
		return {vue:3,itm:76,nLame:69,caption:"de ganglion sympathique"}
	} else if (obj.name.includes("Moelle_épinière")) {
		return {vue:3,itm:82,nLame:56,caption:"de moelle épinière"}
	} else if (obj.name.includes("Ovaire")) {
		return {vue:5,itm:203,nLame:109,caption:"d'ovaire"}
	} 
	return false;
}

function initModelMode () {
	console.log ("init");
	scene2 = new THREE.Scene();
	camera2 = new THREE.PerspectiveCamera(25, 1, 0.1, 3); 
	renderer2 = new THREE.WebGLRenderer({antialias:true});
	renderer2.setClearColor( 0xFFFFFF, 1 );
	renderer2.outputColorSpace = THREE.SRGBColorSpace;
	renderer2.setSize(lGl2,hGl2);
	divModeleGl.appendChild(renderer2.domElement);
	scene2.add(camera2);
	camera2.position.set(0.7,0,0.7);
	controls2 = new OrbitControls(camera2, renderer2.domElement);
	controls2.maxDistance = 1.5;
	controls2.minDistance = 0.2;
	
	directionalLight21 = new THREE.DirectionalLight( 0xffffff);
	directionalLight21.intensity=2;
	directionalLight21.position.set(4,4,4);
	scene2.add(directionalLight21);
	
	directionalLight22 = new THREE.DirectionalLight( 0xffffff);
	directionalLight22.intensity=1;
	directionalLight22.position.set(-4,4,0);
	scene2.add(directionalLight22);
			
	ambientLight2 = new THREE.AmbientLight( 0xffffff ); 
	ambientLight2.intensity=1.4;
	scene2.add(ambientLight2);
}


function disposeGroup (group) {
	group.traverse( function( obj ) {
		if (obj.type!="Group") {
			if (obj?.material) {
				if (typeof(obj?.material)!="undefined") {
					disposeResources(obj.material);
				}
			}
			obj?.geometry?.dispose();
		}
	})
	scene2.remove(group);
}

function disposeResources(mtrl){
	if(mtrl.alphaMap){
		mtrl.alphaMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.alphaMap.source.uuid))
	}
	if(mtrl.aoMap){
		mtrl.aoMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.aoMap.source.uuid))
	}
	if(mtrl.blendDstAlpha){
		mtrl.blendDstAlpha.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.blendDstAlpha.source.uuid))
	}
	if(mtrl.blendEquationAlpha){
		mtrl.blendEquationAlpha.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.blendEquationAlpha.source.uuid))
	}
	if(mtrl.blendSrcAlpha){
		mtrl.blendSrcAlpha.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.blendSrcAlpha.source.uuid))
	}
	if(mtrl.bumpMap){
		mtrl.bumpMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.bumpMap.source.uuid))
	}
	if(mtrl.displacementMap){
		mtrl.displacementMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.displacementMap.source.uuid))
	}
	if(mtrl.emissiveMap){
		mtrl.emissiveMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.emissiveMap.source.uuid))
	}
	if(mtrl.envMap){
		mtrl.envMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.envMap.source.uuid))
	}
	if(mtrl.lightMap){
		mtrl.lightMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.lightMap.source.uuid))
	}
	if(mtrl.map){
		mtrl.map.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.map.source.uuid))
	}
	if(mtrl.metalnessMap){
		mtrl.metalnessMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.metalnessMap.source.uuid))
	}
	if(mtrl.normalMap){
		mtrl.normalMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.normalMap.source.uuid))
	}
	if(mtrl.roughnessMap){
		mtrl.roughnessMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.roughnessMap.source.uuid))
	}
	if(mtrl.specularMap){
		mtrl.specularMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.specularMap.source.uuid))
	}
	if(mtrl.gradientMap){
		mtrl.gradientMap.dispose()
		scene2.remove(scene.getObjectByProperty( 'uuid' ,mtrl.gradientMap.source.uuid))
	}
	mtrl.dispose()
	mtrl=undefined
}


function doShadeSmoothGroup2 (group) {
	// récursif
	// applique un shader smooth et recalcule les normales
	// de tous les enfants de "group"
	
	for (let c of group.children) {
		if (c.children.length>0) {
			doShadeSmoothGroup2(c);
		} else {
			if (c.type=="Mesh") {
				c.material.flatShading=false;
				c.geometry.computeVertexNormals();
			}
		}
	}
}