let scene,camera,renderer;
let distCam0=1.7;
let targetY0=1.3;
let targetRotY0=6;
let distCam=distCam0;
let targetY=targetY0;
let targetRotY=targetRotY0;
let targetDistCam=distCam;
let materialSelect;
let indiceMesh=0;
let setMaterials=new Set();
let listeMaterials=[];
let phi,theta;
let targetPhi,targetTheta;
let isAdaptedToMobile=false;


function initScene () {
	// x => vers la droite
	// y => vers le haut
	// z => vers l'utilisateur
	THREE.ColorManagement.enabled=false;
	scene = new THREE.Scene();
	camera = new THREE.PerspectiveCamera(25, lGl / hGl, 0.05, 6); // en mètres
	renderer = new THREE.WebGLRenderer({antialias:true});
	renderer.setClearColor( 0xFFFFFF, 1 );
	renderer.outputColorSpace = THREE.SRGBColorSpace;
	renderer.setSize(lGl,hGl);
	divGl.appendChild(renderer.domElement);
	scene.add(camera);
	camera.position.set(0,targetY,distCam);
	
	directionalLight = new THREE.DirectionalLight( 0xffffff);
	directionalLight.intensity=2.8;
	directionalLight.position.set(4,4,4);
	scene.add(directionalLight);
	
	directionalLight2 = new THREE.DirectionalLight( 0xffffff);
	directionalLight2.intensity=1;
	directionalLight2.position.set(-4,4,0);
	scene.add(directionalLight2);
			
	ambientLight = new THREE.AmbientLight( 0xffffff ); 
	ambientLight.intensity=0.6;
	scene.add(ambientLight);
	
	modele = new THREE.Object3D();
	modele.name="modele";
	modele.rotation.y=targetRotY0;
	scene.add(modele);
	
	excreteur = new THREE.Object3D();
	excreteur.name="excreteur";
	modele.add(excreteur);
	
	reproducteur = new THREE.Object3D();
	reproducteur.name="reproducteur";
	modele.add(reproducteur);
	
	const map = new THREE.TextureLoader().load( 'images/icones/crosshair.png' );
	const material = new THREE.SpriteMaterial( { 
		map: map,
		depthTest:false,
		opacity:0.5,
		transparent:true
	} );
	curseur = new THREE.Sprite( material );
	scene.add( curseur );
	
	setupSlicer();
	
	materialOs = new THREE.MeshPhysicalMaterial({
		color:0xcb8b4e,
		roughness:0.7,
		name:"Os"
	})
	
	materialCartilage = new THREE.MeshPhysicalMaterial({
		color:0x9fcbcb,
		roughness:0.4,
		clippingPlanes:clipPlanes,
		name:"Cartilage"
	})
	
	materialMuscle = new THREE.MeshPhysicalMaterial({
		color:0x8f2222,
		metalness:0.6,
		roughness:0.9,
		clippingPlanes:clipPlanes,
		name:"Muscle"
	})
	
	materialTendon = new THREE.MeshPhysicalMaterial({
		color:0x999999,
		roughness:0.5,
		clippingPlanes:clipPlanes,
		name:"Tendon"
	})
	
	materialLigament = new THREE.MeshPhysicalMaterial({
		color:13421772,
		roughness:0.4,
		clippingPlanes:clipPlanes,
		name:"Ligament"
	})
	
	materialSelect= new THREE.MeshPhongMaterial({
		side: THREE.DoubleSide,
		clippingPlanes:clipPlanes,
		opacity:0.5,
		emissiveIntensity:0.15
	})
	
	materialSearch= new THREE.MeshBasicMaterial({
		clippingPlanes:clipPlanes,
		transparent:true,
		depthTest:false
	})
	
	// const axesHelper = new THREE.AxesHelper( 1.75 );
	// scene.add( axesHelper );


}



function doShadeSmoothGroup (group,forceSmooth) {
	// récursif
	// applique un shader smooth et recalcule les normales
	// de tous les enfants de "group"
	// permet d'exporter les objets sans les normales
	if (typeof(forceSmooth)=="undefined") {forceSmooth=true}
	//makeAllMaterialsPhong(group);
	for (let c of group.children) {
		if (c.type=="Mesh") {
			indiceMesh++;
			if (c.material.name.includes("Bone")||c.material.name.includes("Os")) {
				c.material=materialOs;
			}
			else if (c.material.name.includes("Cartilage")) {
				c.material=materialCartilage;
			}
			else if (c.material.name.includes("Muscle")) {
				c.material=materialMuscle;
			}
			else if (c.material.name.includes("Tendon")) {
				c.material=materialTendon;
			}
			else if (c.material.name.includes("Ligament")) {
				c.material=materialLigament;
			}
			
			c.material.clippingPlanes=clipPlanes;
			
			c.userData.isOrgan=true;
			c.userData.oriMaterial=c.material;
			c.userData.indiceMesh=indiceMesh;
			
			setMaterials.add(c.material);
			c.material.side=THREE.FrontSide;
			
			if (forceSmooth) {
				c.material.flatShading=false;
				c.geometry.computeVertexNormals();
			}
		}
		if (c.children.length>0) {
			doShadeSmoothGroup(c,forceSmooth);
		} 
	}
	buildListeMaterials ();
}

function buildListeMaterials() {
	let tempListeMaterials=Array.from(setMaterials);
	listeMaterials=[];
	let gutsMaterialTemplate = new THREE.MeshBasicMaterial( {color: 'white', side: THREE.BackSide, clippingPlanes: clipPlanes} );
	for (let mat of tempListeMaterials) {
		let gutMat=gutsMaterialTemplate.clone();
		gutMat.color=mat.color.clone();
		gutMat.transparent=mat.transparent;
		gutMat.opacity=mat.opacity;
		gutMat.name=mat.name;
		listeMaterials.push({ori:mat,gut:gutMat});
	}
}

function restoreOldMaterial () {
	if (typeof(oldObject)!="undefined") {
		if (oldObject.material==materialSearch) {return false}
		restoreMaterial(oldObject);
		oldObject=undefined;
	}	
}

function restoreMaterial (obj) {
	if (typeof(obj.userData.currentMaterial)!="undefined") {
		obj.material=obj.userData.currentMaterial;
	} else {		
		obj.material=obj.userData.oriMaterial;
	}
}

function getInfoFromXY (x,y) {
	if (divCtxMenu.style.display!="none") {return false}
	if (!overGl) {return false}
	restoreOldMaterial();
	
	let interAtXY=getInterUnderCursor(x,y);
	
	if (interAtXY) {
		let objAtXY=interAtXY.object;
		let nom=cleanNameFromObj(objAtXY);
		
		doSelectObj(objAtXY);
		lastXInfobulle=x;
		lastYInfobulle=y;
		divInfoBulle.style.opacity=1;
		nom=nom.replace("(","<br>(");
		divInfoBulle.innerHTML=nom;
		shrinkWrap(divInfoBulle);
		doDico(objAtXY);
	} else {
		divInfoBulle.style.opacity=0;
	}
	divInfoBulle.style.left=x+hFont+"px";
	divInfoBulle.style.top=y+hFont+"px";
	
	lastInfoX=lastMouseX;
	lastInfoY=lastMouseY;
}

function doSelectObj (objAtXY) {
	if (objAtXY.material!=materialSearch) {
		// on enregistre l'ancien objet
		oldObject=objAtXY;
		materialSelect.color=objAtXY.material.color.clone();
		objAtXY.material=materialSelect;
		if ((objAtXY.isMadeTransp)||(objAtXY.userData.oriMaterial.transparent)) {
			materialSelect.transparent=true;
			materialSelect.side=THREE.FrontSide;
			materialSelect.needsUpdate=true;
		} else {
			materialSelect.transparent=false;
			materialSelect.side=THREE.DoubleSide;
			materialSelect.needsUpdate=true;
		}
	}
}

function checkVisiDansScene (leg) {
	var mousePos = new THREE.Vector2();
	mousePos.x = ( leg.x / lGl ) * 2 - 1;
	mousePos.y = - ( leg.y / hGl ) * 2 + 1;
	var raycaster = new THREE.Raycaster();
	raycaster.setFromCamera( mousePos, camera );
	
	let rc=raycaster.intersectObjects( scene.children );
		
	var intersects = raycaster.intersectObjects( scene.children ).filter(c=>(allParentVisible(c.object)||(c.object==leg.sphere))
		&&(c.object.type=="Mesh")&&(c.object.type!="PlaneHelper"));
	
	if (isSlicerActif) {
		// on filtre tous les points à gauche (x) du plan sagittal ou en face (z) du plan coronal
		// mais il faut au préalable passer en coordonnées locales (par rapport au modèle)
		for (let interGlobal of intersects) {
			let globalPos = interGlobal.point.clone();
			interGlobal.localPos=modele.worldToLocal (globalPos);
		}
		if (sliceOrient=="sagittal") {
			intersects=intersects.filter (c=>(c.object==leg.sphere)||(c.localPos.x>-planeCsteSag));
		} else if (sliceOrient=="coronal") {
			intersects=intersects.filter (c=>(c.object==leg.sphere)||(c.localPos.z<planeCsteCor));
		} else if (sliceOrient=="axial") {
			intersects=intersects.filter (c=>(c.object==leg.sphere)||(c.localPos.y<planeCsteAxi));
		}
	}
	if  (intersects.length==0) {return false}
	let inter0=intersects[0];
	if (inter0.object!=leg.sphere) {return false}
	if (isSlicerActif) {
		tolerance=0.01;
		if (sliceOrient=="sagittal") {
			if ((inter0.localPos.x+tolerance)<-planeCsteSag) {return false}
		} else if (sliceOrient=="coronal") {
			if ((inter0.localPos.z-tolerance)>planeCsteCor) {return false}
		} else if (sliceOrient=="axial") {
			if ((inter0.localPos.y-tolerance)>planeCsteAxi) {return false}
		}
	}
	return true;
}


function hideUnderCursor (x,y) {
	let interAtXY=getInterUnderCursor(x,y);
	if (interAtXY) {
		let objAtXY=interAtXY.object;
		objAtXY.visible=false;
	} 
}

function getOrganeComposite (obj) {
	// l'export en .glb sépare en plusieurs objets, les objets comportant plusieurs matériaux
	// ex. un objet pour l'os, un objet pour son cartilage.
	// les 2 sont cependant réunis comme enfants d'un même objet parent
	// cette fonction renvoie la liste des objets correspondant à l'objet d'origine avant export
	let objetComposite=(obj.name.split("|")[0]==obj.parent.name.split("|")[0]);
	let typeMuscle=(obj?.userData?.oriMaterial?.name=="Muscle")||(obj?.userData?.oriMaterial?.name=="Os")
		||(obj?.userData?.oriMaterial?.name=="Tendon")||(obj?.userData?.oriMaterial?.name=="Cartilage");
	if (objetComposite&&typeMuscle) {
		// il s'agit d'un muscle ou d'un os, on renvoie l'objet parent qui contient l'ensemble
		return obj.parent;
	} else {
		return obj;
	}
}

function hideObjDroit () {
	ctxMouseOut();
	let organes=getOrganeComposite(objDroit);
	organes.traverse( function( object ) {
		object.visible=false;
	})
}

function setAllParentVisible (obj) {
	while (obj.name!="modele") {
		obj.visible=true;
		obj=obj.parent;
	}
	modele.visible=true;
}

function setAllChildrenVisible (obj) {
	obj.traverse( function( object ) {
		object.visible=true;
	})
	modele.visible=true;
}

function isoleObjDroit () {
	ctxMouseOut();
	maskAll();
	let organes=getOrganeComposite(objDroit);
	setAllParentVisible (organes);
	setAllChildrenVisible (organes);
}

function objUnderCursor (x,y) {
	let interAtXY=getInterUnderCursor(x,y);
	if (interAtXY) {
		objDroit=interAtXY.object;
		toClipboard(objDroit.name.split("|")[0]);
		return objDroit;
	} 
	return false
}

function cancelInfoBulle () {
	hideDico();
	lastXInfobulle=0;
	lastYInfobulle=0;
	divInfoBulle.style.opacity=0;
	// on rétablit l'ancien objet
	restoreOldMaterial();
}

function getInterUnderCursor(x,y) {
	var offsets = divGl.getBoundingClientRect();
	var top = offsets.top;
	var left = offsets.left;
	var mouseX = x - left;
	var mouseY = y - top;
	var mousePos = new THREE.Vector2();
	mousePos.x = ( mouseX / lGl ) * 2 - 1;
	mousePos.y = - ( mouseY/ hGl ) * 2 + 1;
	var raycaster = new THREE.Raycaster();
	raycaster.setFromCamera( mousePos, camera );
	
	var intersects = raycaster.intersectObjects( scene.children ).filter(c=>allParentVisible(c.object)&&(c.object.userData.isOrgan));
	
	if (isSlicerActif) {
		// on filtre tous les points à gauche (x) du plan sagittal ou en face (z) du plan coronal
		// mais il faut au préalable passer en coordonnées locales (par rapport au modèle)
		for (let interGlobal of intersects) {
			let globalPos = interGlobal.point.clone();
			interGlobal.localPos=modele.worldToLocal (globalPos);
		}
		if (sliceOrient=="sagittal") {
			intersects=intersects.filter (c=>c.localPos.x>-planeCsteSag);
		} else if (sliceOrient=="coronal") {
			intersects=intersects.filter (c=>c.localPos.z<planeCsteCor);
		} else if (sliceOrient=="axial") {
			intersects=intersects.filter (c=>c.localPos.y<planeCsteAxi);
		}
	}
	
	if (intersects.length==0) {return false}
	if (intersects[0].object.isGut) {
		// on récupère l'objet original associé au gut
		let oriObj=findObjByIndiceMesh(intersects[0].object.userData.indiceMesh);
		// on remplace le gut par l'objet original
		intersects[0].object=oriObj
	}
	return intersects[0];
}

function findObjByIndiceMesh (indice) {
	indice=indice;
	trouve=false;
	modele.traverse( function( object ) {
		if (object.userData.isOrgan) {
			if (object.userData.indiceMesh==indice) {
				trouve=object;
			}
		}
	})
	return trouve;
}


function transpObjDroit () {
	ctxMouseOut();
	let organes=getOrganeComposite(objDroit);
	organes.traverse( function( object ) {
		rendMatTranspGroup(object);
	})
	closeCtxMenu();
}

function restoreOriMatObjDroit () {
	ctxMouseOut();
	let organes=getOrganeComposite(objDroit);
	organes.traverse( function( object ) {
		restoreOriMatObj(object);
	})
	//rendMatTranspGroup(objDroit);
	closeCtxMenu();
}

function restoreOpaMatObjDroit () {
	let organes=getOrganeComposite(objDroit);
	organes.traverse( function( object ) {
		restoreOpacity(object);
	})
	closeCtxMenu();
}

function restoreOriMatObj (obj) {
	delete obj.userData.currentMaterial;
	obj.isMadeTransp=false;
	obj.material=obj.userData.oriMaterial;
	obj.material.needsUpdate=true;
}

function restoreOpacity (obj) {
	if (!obj?.userData?.isOrgan) {return false}
	obj.isMadeTransp=false;
	obj.material=obj.userData.currentMaterial.clone();
	obj.material.transparent=obj.userData.oriMaterial.transparent;
	obj.material.opacity=obj.userData.oriMaterial.opacity;
	if (JSON.stringify(obj.material) === JSON.stringify(obj.userData.oriMaterial)) {
		// on est revenu à l'original
		obj.material=obj.userData.oriMaterial;
		delete obj.userData.currentMaterial;
	} else {
		obj.userData.currentMaterial=obj.material.clone();
	}
	obj.material.needsUpdate=true;
}

function restoreOpacityGroup (group) {
	group.traverse( function( obj ) {
		restoreOpacity(obj);
	})
}

function restoreOpacityContain (group,liste) {
	group.traverse( function( obj ) {
		if (obj.userData.isOrgan) {
			let listeMots=extraitsMotsFromNomObj(obj);
			if (listeMots.some(c => liste.includes(c))) {
				restoreOpacity(obj);
			}
		}
	})
}

function rendMatTranspListe (app,nom,alpha) {
	let liste=getOrgansByName(app,nom);
	for (let org of liste) {rendMatTranspGroup(org,alpha)}
}

function rendMatTranspObj (obj,alpha) {
	if (typeof(alpha)=="undefined") {alpha=0.5}
	if (typeof(obj.userData.currentMaterial)!="undefined") {
		obj.material=obj.userData.currentMaterial.clone();
	} else {
		obj.material=obj.userData.oriMaterial.clone();
	}
	if (alpha<1) {
		obj.isMadeTransp=true;
		obj.material.transparent=true;
		obj.material.opacity=alpha;	
		obj.material.alphaTest=0;	
	} else {
		obj.isMadeTransp=false;
		obj.material.transparent=false;
		obj.material.opacity=1;	
	}
	obj.userData.currentMaterial=obj.material.clone();
	obj.material.needsUpdate=true;
}

function rendMatTranspGroup (group,alpha) {
	if (typeof(alpha)=="undefined") {alpha=0.5}
	group.traverse( function( obj ) {
		if (obj.userData.isOrgan) {
			rendMatTranspObj(obj,alpha);
		}
	})
}


function teinteGroup (group,coul) {
	// rajoute une teinte sous la forme d'un emissive
	group.traverse( function( obj ) {
		if (obj.userData.isOrgan) {
			obj.material=obj.userData.oriMaterial.clone();
			obj.material.emissiveIntensity=0.5;
			obj.material.emissive.set(coul);
			obj.userData.currentMaterial=obj.material.clone();
			obj.material.needsUpdate=true;
		}
	})
}

function coloreGroup (group,coul) {
	// change la couleur d'un groupe
	group.traverse( function( obj ) {
		if (obj.userData.isOrgan) {
			obj.material=obj.userData.oriMaterial.clone();
			obj.material.color.set(coul);
			obj.userData.currentMaterial=obj.material.clone();
			obj.material.needsUpdate=true;
		}
	})
}


function restoreAllOriMat () {
	for (let app of tAllOrgans) {
		let appareil=window[app];
		if (appareil?.children?.length>0) {
			appareil.traverse( function( object ) {
				if (object.userData.isOrgan) {
					restoreOriMatObj(object);
				}
			})
		}
	}
}

function restoreAllOpacity () {
	for (let app of tAllOrgans) {
		let appareil=window[app];
		if (appareil?.children?.length>0) {
			appareil.traverse( function( object ) {
				if (object.userData.isOrgan) {
					if (object.isMadeTransp) {
						restoreOpacity(object);
					}
				}
			})
		}
	}
}

function movePOV (deltaX,deltaY) {
	if (modePivot) {
		targetPhi+=deltaX/hGl*6;
		targetTheta-=deltaY/hGl*6;
		targetPhi=targetPhi%(Math.PI*2);
		if (targetTheta<0.001) {targetTheta=0.001}
		else if (targetTheta>3.14) {targetTheta=3.14}
	} else {
		targetRotY+=deltaX/hGl*6;
		targetRotY=targetRotY%(Math.PI*2);
		targetY+=deltaY/hGl*distCam*0.4;
		if (targetY>2.2) {targetY=2.2}
		if (targetY<-0.4) {targetY=-0.4}
	}
}

function updatePOV(dTime) {
	if (modePivot) {
		// phi = longitude
		// theta = 0 quand pôle
		let deltaPhi=Math.atan2(Math.sin(targetPhi-phi), Math.cos(targetPhi-phi))
		let deltaTheta=Math.atan2(Math.sin(targetTheta-theta), Math.cos(targetTheta-theta))
		phi+=deltaPhi*dTime*0.01;
		theta+=deltaTheta*dTime*0.01;
		distCam=(distCam*coefSmoothMove + targetDistCam*dTime) / (coefSmoothMove+dTime);
		camera.position.x = distCam * Math.sin(theta) * Math.cos(phi) + pivotCenter.x;
		camera.position.z = distCam * Math.sin(theta) * Math.sin(phi) + pivotCenter.z;
		camera.position.y = distCam * Math.cos(theta) + pivotCenter.y;
		camera.lookAt (curseur.position);
		
		let sc=distCam*0.01;
		curseur.scale.set(sc,sc,sc);
		curseur.visible=true;
	} else {
		distCam=(distCam*coefSmoothMove + targetDistCam*dTime) / (coefSmoothMove+dTime);
		curseur.visible=false;
		camera.position.y=(camera.position.y*coefSmoothMove + targetY*dTime) / (coefSmoothMove+dTime);
		let deltaAngle=Math.atan2(Math.sin(targetRotY-modele.rotation.y), Math.cos(targetRotY-modele.rotation.y))
		modele.rotation.y+=deltaAngle*dTime*0.01;
		modele.rotation.y=modele.rotation.y%(Math.PI*2);
		checkTargetYLimits();
		camera.position.z=distCam;
	}
		
	if (isSlicerActif) {rotateSlicer()}
}

function allParentVisible (obj) {
	// vérifie si l'objet est visible ainsi que tous ses parents
	if (obj.parent===null) {
		// fin de la récursion
		return obj.visible||false;
	}
	if (obj.visible==false) {return false}
	return allParentVisible(obj.parent)
}

